/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.network;

import io.netty.buffer.ByteBuf;
import java.nio.charset.Charset;
import java.util.function.BooleanSupplier;
import net.dries007.tfc.ConfigTFC;
import net.dries007.tfc.TerraFirmaCraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketSimpleMessage
implements IMessage {
    private ITextComponent text;
    private MessageCategory category;

    public static PacketSimpleMessage translateMessage(MessageCategory category, String unlocalized, Object ... args) {
        return new PacketSimpleMessage(category, (ITextComponent)new TextComponentTranslation(unlocalized, args));
    }

    public static PacketSimpleMessage stringMessage(MessageCategory category, String localized) {
        return new PacketSimpleMessage(category, (ITextComponent)new TextComponentString(localized));
    }

    public PacketSimpleMessage() {
    }

    public PacketSimpleMessage(MessageCategory category, ITextComponent text) {
        this.text = text;
        this.category = category;
    }

    public void fromBytes(ByteBuf buf) {
        this.category = MessageCategory.values()[buf.readInt()];
        this.text = ITextComponent.Serializer.func_150699_a((String)buf.readCharSequence(buf.readInt(), Charset.defaultCharset()).toString());
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.category.ordinal());
        String json = ITextComponent.Serializer.func_150696_a((ITextComponent)this.text);
        buf.writeInt(json.length());
        buf.writeCharSequence((CharSequence)json, Charset.defaultCharset());
    }

    public static final class Handler
    implements IMessageHandler<PacketSimpleMessage, IMessage> {
        public IMessage onMessage(PacketSimpleMessage message, MessageContext ctx) {
            TerraFirmaCraft.getProxy().getThreadListener(ctx).func_152344_a(() -> {
                EntityPlayer player = TerraFirmaCraft.getProxy().getPlayer(ctx);
                if (player != null) {
                    player.func_146105_b(message.text, message.category.displayToToolbar.getAsBoolean());
                }
            });
            return null;
        }
    }

    public static enum MessageCategory {
        ANVIL(() -> ConfigTFC.Client.TOOLTIP.anvilWeldOutputToActionBar),
        VESSEL(() -> ConfigTFC.Client.TOOLTIP.vesselOutputToActionBar),
        ANIMAL(() -> ConfigTFC.Client.TOOLTIP.animalsOutputToActionBar);

        private final BooleanSupplier displayToToolbar;

        private MessageCategory(BooleanSupplier displayToToolbar) {
            this.displayToToolbar = displayToToolbar;
        }
    }
}

